/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.teastory.data.model;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import xueluoanping.teastory.TeaStory;
import xueluoanping.teastory.registry.BlockRegister;
import xueluoanping.teastory.registry.FluidRegistry;

public class BlockStatesDataProvider
extends BlockStateProvider {
    private final ExistingFileHelper existingFileHelper;

    public BlockStatesDataProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "teastory", existingFileHelper);
        this.existingFileHelper = existingFileHelper;
    }

    protected void registerStatesAndModels() {
        for (RegistryObject registryObject : FluidRegistry.BLOCKS.getEntries()) {
            this.simpleBlock((Block)registryObject.get(), ConfiguredModel.builder().modelFile((ModelFile)this.models().withExistingParent("water", new ResourceLocation("water"))).build());
        }
        for (RegistryObject registryObject : List.of(BlockRegister.WILD_CUCUMBER, BlockRegister.WILD_BITTER_GOURD, BlockRegister.WILD_RICE, BlockRegister.WILD_CHILI, BlockRegister.WILD_CHINESE_CABBAGE)) {
            this.simpleBlock((Block)registryObject.get(), ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.blockName((Block)registryObject.get()), new ResourceLocation("cross"))).texture("cross", BlockStatesDataProvider.resourceBlock(this.blockName((Block)registryObject.get())))).build());
        }
    }

    public void customStageBlock(Block block, @Nullable ResourceLocation parent, String textureKey, IntegerProperty ageProperty, List<Integer> suffixes, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.m_61143_((Property)ageProperty);
            String stageName = this.blockName(block) + "_stage_";
            stageName = stageName + (suffixes.isEmpty() ? ageSuffix : (Integer)suffixes.get(Math.min(suffixes.size() - 1, ageSuffix)));
            if (parent == null) {
                return ConfiguredModel.builder().modelFile((ModelFile)this.models().cross(stageName, BlockStatesDataProvider.resourceBlock(stageName))).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().singleTexture(stageName, parent, textureKey, BlockStatesDataProvider.resourceBlock(stageName))).build();
        }, ignored);
    }

    private String blockName(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_();
    }

    public static ResourceLocation resourceBlock(String path) {
        return TeaStory.rl("block/" + path);
    }

    public ResourceLocation resourceVanillaBlock(String path) {
        return new ResourceLocation("block/" + path);
    }

    public static int getRotateYByFacing(Direction state) {
        switch (state) {
            case EAST: {
                return 90;
            }
            case SOUTH: {
                return 180;
            }
            case WEST: {
                return 270;
            }
        }
        return 0;
    }
}

